
/////////////////////////////////////////////////////////
// general parameters

//transforms

float4x4	shader_transform_world;
float4x4	shader_transform_view;
float4x4	shader_transform_proj;
float4x4	shader_transform_worldView;
float4x4	shader_transform_viewProj;
float4x4	shader_transform_worldViewProj;

//lights

float4		shader_light_position;
float4		shader_light_direction;
float4		shader_light_diffuse;
float4		shader_light_ambient;
float4		shader_light_specular;
float4x4	shader_light_view;
float4x4	shader_light_viewProj;

//camera

float4 		shader_camera_eyePosition;
float4 		shader_camera_eyeVector;
float4 		shader_camera_upVector;

//material

float4		shader_material_diffuse;
float4		shader_material_ambient;
float4		shader_material_specular;
float		shader_material_eccentricity;
float		shader_material_transparency;
float		shader_material_reflectivity;

//textures

TEXTURE		shader_texture_0;
TEXTURE		shader_texture_1;
TEXTURE		shader_texture_2;
TEXTURE		shader_texture_3;
TEXTURE		shader_texture_4;
TEXTURE		shader_texture_5;
TEXTURE		shader_texture_cubemap;
TEXTURE		shader_texture_shadowmap;

//geometry

float4		shader_geometry_colour;

/////////////////////////////////////////////////////////
// unique parameters

#define		SHADOW_EPSILON 0.0005f
float4x4	g_shadowerTransform;
float		g_light_farPlane;
float		shader_misc_shadow_mapSize;
float		shader_misc_shadow_mapTexelSize;

float		shader_misc_rotorOpacity;
float		shader_misc_highlightOpacity;
float		shader_misc_rotorReflection;
float4x4	shader_misc_highlightTransform;
float4x4	shader_misc_rotationTransform;

float3		rotorBlur_camera_eyePosition;
float3		rotorBlur_light_direction;

////////////////////////////////////////////////////////////////////
// structures

struct VS_INPUT
{
	float4 position		: POSITION;
	float3 normal		: NORMAL;
	float4 colour		: COLOR;
	float2 tex0			: TEXCOORD0;
};


struct VS_OUTPUT_HIGH
{
	float4 position			: POSITION;
	float2 tex0				: TEXCOORD0;
	float2 tex1				: TEXCOORD1;
	float2 tex2				: TEXCOORD2;
	float  lightIntensity	: TEXCOORD3;
};

////////////////////////////////////////////////////////////////////
// functions

VS_OUTPUT_HIGH vs_rotorBlur_cockpit( VS_INPUT input )
{
	VS_OUTPUT_HIGH output = (VS_OUTPUT_HIGH) 0;

	// Output the transformed position
	output.position = mul(input.position, shader_transform_world);
	float3 nOutputNormal = normalize(mul(input.normal, (float3x3)shader_transform_world));
		
	float3 vCamera = normalize(output.position);
	float3 vHalfway = normalize(-rotorBlur_light_direction - vCamera);
	
	output.lightIntensity = 0.5f; //clamp(saturate(dot( nOutputNormal, -vCamera )),0.1,1) * shader_light_diffuse.r;

	output.position = mul(output.position, shader_transform_viewProj);

  	output.tex0 = input.tex0;

	output.tex1 = mul(float2(input.position.x*0.5,input.position.z*0.5), shader_misc_rotationTransform) + float2(0.5,0.5);
	
	output.tex2 = mul(float2(input.position.x*0.5,input.position.z*0.5), shader_misc_highlightTransform) + float2(0.5,0.5);

	return output;
}

sampler sampler_colour_0 = sampler_state { Texture = (shader_texture_0); };
sampler sampler_colour_1 = sampler_state { Texture = (shader_texture_1); };

float4 ps_rotorBlur_cockpit( VS_OUTPUT_HIGH input ) : COLOR0
{
	float4 nDiskColour = tex2D(sampler_colour_0, input.tex0);
	nDiskColour.a *= (tex2D(sampler_colour_1, input.tex1).a * shader_misc_rotorOpacity * input.lightIntensity);
	
	float nReflectionColour = tex2D(sampler_colour_1, input.tex2).r * shader_misc_highlightOpacity * shader_misc_rotorReflection * shader_light_diffuse.r;
	
	return lerp(nDiskColour, float4(1,1,1,nDiskColour.a + tex2D(sampler_colour_1, input.tex2).r), nReflectionColour);
}

////////////////////////////////////////////////////////////////////

struct VS_OUTPUT_BASE
{
	float4 position			: POSITION;
	float4 colour			: COLOR;
	float2 tex0				: TEXCOORD0;
};

VS_OUTPUT_BASE vs_rotorBlur_cockpit_base( VS_INPUT input )
{
	VS_OUTPUT_BASE output = (VS_OUTPUT_BASE) 0;

	// Output the transformed position
	output.position = mul(input.position, shader_transform_world);
	output.position = mul(output.position, shader_transform_viewProj);

  	output.tex0 = input.tex0;
  	
  	output.colour = float4(1,1,1,shader_misc_rotorOpacity * 0.25);

	return output;
}

////////////////////////////////////////////////////////////////////
// techniques

technique rotorBlur_cockpit_11_00
{
	pass P0
	{
		VertexShader = compile vs_1_1 vs_rotorBlur_cockpit_base();	
	}
}


technique rotorBlur_cockpit_11_20
{
	pass P0
	{
		VertexShader = compile vs_1_1 vs_rotorBlur_cockpit();	
		PixelShader = compile ps_2_0 ps_rotorBlur_cockpit();	
	}
}

////////////////////////////////////////////////////////////
